jQuery(document).ready(function($) {
    
    // Generalized function to handle form submission via AJAX
    function handleFormSubmission(formId, action, formData, messageContainerId, onSuccessCallback) {
        var $message = $(messageContainerId);
        $message.hide().removeClass('notice-success notice-error').text('');
        
        $.ajax({
            url: gfdt_ajax_obj.ajax_url, 
            method: 'POST',
            data: formData,
            success: function(response) {
                if (response.success) {
                    $message
                        .addClass('notice-success')
                        .text('Settings saved successfully!')
                        .show();
                        if (typeof onSuccessCallback === 'function') {
                            onSuccessCallback();
                        }
                } else {
                    $message
                        .addClass('notice-error')
                        .text('Error: ' + response.data.message)
                        .show();
                }
            },
            error: function(xhr, status, error) {
                console.error(xhr, status, error);
                $message
                    .addClass('notice-error')
                    .text('An error occurred while saving settings. Please try again.')
                    .show(); 
                console.error('AJAX Error:', error);
            }
        });
    }

    // Submit Form Settings
    $('#gfdt-settings').submit(function(event) {
        event.preventDefault();  

        var isMappingEnabled = $('#gfdt_field_mapping_enabled').is(':checked');
        var campaignValue = $('#gfdt_campaign').val().trim();
        
        if (isMappingEnabled && !campaignValue) {
            $('#gfdt-message')
                .addClass('notice-error')
                .text('You must provide a default Donorfy Campaign to map to')
                .show();
            return; 
        }

        var formData = {
            action: 'gfdt_save_settings',
            nonce: gfdt_ajax_obj.nonce,   
            gfdt_field_mapping_enabled: isMappingEnabled ? 1 : 0,
            gfdt_form_id: $('#gfdt_field_mapping_enabled').val(),
            gfdt_campaign: campaignValue
        };
            handleFormSubmission('#gfdt-settings', 'gfdt_save_settings', formData, '#gfdt-message');
    });

    // Submit core settings
    $('#gfdt-donorfy-settings').submit(function(event) {
        event.preventDefault();

        var donorfyApiKey = $('#gfdt_donorfy_api_key').val().trim();
        var donorfyAccessKey = $('#gfdt_donorfy_access_key').val().trim();
       

        // Validate if keys are still empty
        if ((donorfyApiKey === '' || donorfyApiKey === '0') || (donorfyAccessKey === '' || donorfyAccessKey === '0')) {
            $('#gfdt-donorfy-message')
                .addClass('notice-error')
                .text('Both Donorfy API Key and Access Key are required')
                .show();
            return;
        }

        var donorfyData = {
            action: 'gfdt_save_core_settings', 
            nonce: gfdt_ajax_obj.nonce,   
            gfdt_donorfy_api_key: donorfyApiKey,
            gfdt_donorfy_access_key: donorfyAccessKey
        };

        handleFormSubmission('#gfdt-donorfy-settings', 'gfdt_save_core_settings', donorfyData, '#gfdt-message');
    });

    $('#gfdt-clear-settings').click(function(event) {
        event.preventDefault(); 
        event.stopPropagation(); 
        var donorfyData = {
            action: 'gfdt_save_core_settings', 
            nonce: gfdt_ajax_obj.nonce,   
            gfdt_donorfy_api_key: "0",
            gfdt_donorfy_access_key: "0"
        };

        handleFormSubmission('#gfdt-donorfy-settings', 'gfdt_save_core_settings', donorfyData, '#gfdt-message', function() {
            $('#gfdt_donorfy_api_key').val('');
            $('#gfdt_donorfy_access_key').val('');
        });
    });


});
