<?php

if (!defined('ABSPATH')) exit;

class GFDT_Data_Transmit {
    
    public static function init() {
        add_action('gform_after_submission', [__CLASS__, 'transmit_data'], 10, 2);
    }

    public static function transmit_data($entry, $form) {
        
   $enabled_form_ids = get_option('gfdt_field_mapping_enabled', '');
   $enabled_form_ids_array = explode(',', $enabled_form_ids);
   $CTID = get_option('gfdt_CTID', '');
   
if (!in_array($form['id'], $enabled_form_ids_array) || $sendKey === '0' || $sendAccess === '0') {
        return; 
    } 
	
    $json_data = $entry;
	$item_for_sale_count = 0;
    
    if (!empty($CTID)) {
    $json_data['CTID'] = $CTID;
	}
    $campaign_mapping = get_option('gfdt_campaign', '');
    $campaign_mapping_array = explode(',', $campaign_mapping);
    foreach ($campaign_mapping_array as $mapping) {
            if (empty($mapping)) {
              continue;
          }
          list($mapping_form_id, $campaign_name) = explode('--', $mapping);
          if ((string) $mapping_form_id === (string)$form['id']) { 
              $donCampaign = $campaign_name;
              break;
          }
    }
      if (!empty($donCampaign)) {
        $json_data['DefaultCampaign'] = $donCampaign;
    }
     
    foreach ($form['fields'] as $field) {
        if (!empty($field->adminLabel) && $field->adminLabel === 'OrderItem') {
            $item_for_sale_count++;
            $label_with_count = 'OrderItem-' . $item_for_sale_count;

            if (isset($field->inputs) && is_array($field->inputs)) {
                foreach ($field->inputs as $input) {
                    $json_data[$label_with_count . '-' . $input['label']] = rgar($entry, $input['id']);
                }
            } else {
                $json_data[$label_with_count] = rgar($entry, $field->id);
            }
        } elseif (!empty($field->adminLabel)) {
            if ($field->type === 'address' && isset($field->inputs) && is_array($field->inputs)) {
                foreach ($field->inputs as $input) {
                    $id_suffix = substr(strrchr($input['id'], '.'), 1);
    
                    switch ($id_suffix) {
                        case '1':
                            $json_data['AddressLine1'] = rgar($entry, $input['id']);
                            break;
                        case '2':
                            $json_data['AddressLine2'] = rgar($entry, $input['id']);
                            break;
                        case '3':
                            $json_data['Town'] = rgar($entry, $input['id']);
                            break;
                        case '4':
                            $json_data['County'] = rgar($entry, $input['id']);
                            break;
                        case '5':
                            $json_data['PostalCode'] = rgar($entry, $input['id']);
                            break;
                        case '6':
                            $json_data['Country'] = rgar($entry, $input['id']);
                            break;
                    }
                }
            } elseif ($field->type === 'name' && isset($field->inputs) && is_array($field->inputs)) {
                foreach ($field->inputs as $input) {
                    $id_suffix = substr(strrchr($input['id'], '.'), 1);
            
                    switch ($id_suffix) {
                        case '3': // "First"
                            $json_data['FirstName'] = rgar($entry, $input['id']);
                            break;
                        case '6': // "Last"
                            $json_data['LastName'] = rgar($entry, $input['id']);
                            break;
                    }
                }
            } 
			elseif ($field->adminLabel === 'Purpose') {
				$value = rgar($entry, $field->id);
				if (!empty($value)) {
					if (!isset($json_data['Purposes'])) {
						$json_data['Purposes'] = trim($value);
					} else {
						$json_data['Purposes'] .= ',' . trim($value);
					}
				}
			}
			elseif ($field->adminLabel === 'Tag') {
				$value = rgar($entry, $field->id);
				if (!empty($value)) {
					if (!isset($json_data['Tags'])) {
						$json_data['Tags'] = trim($value);
					} else {
						$json_data['Tags'] .= ',' . trim($value);
					}
				}
			}
			
			elseif (isset($field->inputs) && is_array($field->inputs)) {
                $values = [];
                    foreach ($field->inputs as $input) {
                        $value = rgar($entry, $input['id']);	
                        if (!empty($value)) {
                            $values[] = $value;
                        }
                    }
                    $json_data[$field->adminLabel] = count($values) > 1 ? implode(', ', $values) : ($values[0] ?? '');
            } else {
                $json_data[$field->adminLabel] = rgar($entry, $field->id);
            }
        } elseif ($field->type == 'hidden') {
            $json_data[$field->label] = rgar($entry, $field->id);
        } else {
            $json_data[$field->id] = rgar($entry, $field->id);
        }
    }
    $json_data['SourceURL'] = rgar($entry, 'source_url');
    $json_data['PaymentDate'] = rgar($entry, 'date_updated');
    $json_data['SubmissionID'] = rgar($entry, 'id');
    $entry_id = $entry['id'];
   
    
   $json_data = json_encode($json_data);
	//error_log('data sent: ' . $json_data); 
	self::send_data_remote('https://hiowaa.gravity.charitytoolkit.uk/gfdt-send.php', $json_data);
	
    }
    
private static function send_data_remote($url, $json_data) {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json', 
            'Content-Length: ' . strlen($json_data) 
        ]);
        curl_setopt($ch, CURLOPT_POST, true);  
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json_data);

        $response = curl_exec($ch);
        curl_close($ch);

        if ($response === false) {
            error_log("Error sending data: " . curl_error($ch));
        }
    }



}

GFDT_Data_Transmit::init();
