<?php 
class GFDT_Donorfy_API {
    private $baseurl;
    public function __construct($baseurl) {
        $this->baseurl = $baseurl;
    }

public function post_data( $json, $auth_token, $query_url_endpoint ) { // POST function
    $query_url = $this->baseurl . $query_url_endpoint;
    $args = [
        'method'      => 'POST',
        'timeout'     => 60,
        'redirection' => 10,
        'headers'     => [
            'Authorization' => 'Basic ' . $auth_token,
            'Content-Type'  => 'application/json',
        ],
        'body'        => $json,
    ];
    $response = wp_remote_post( $query_url, $args );
    if ( is_wp_error( $response ) ) {
        error_log( 'Request failed: ' . $response->get_error_message() );
        return false;
    }
    $status_code = wp_remote_retrieve_response_code( $response );
    $response_body = wp_remote_retrieve_body( $response );
    //error_log( 'Post Response Code: ' . $status_code );
   // error_log( 'Post Response Body: ' . $response_body );
    return [
        'status' => $status_code,
        'body'   => json_decode( $response_body, true ),
    ];
} // END POST function

public function get_data($auth_token, $query_url_endpoint) { // GET function
    $query_url = $this->baseurl . $query_url_endpoint;
    $args = [
        'method'      => 'GET', 
        'timeout'     => 60,
        'redirection' => 10,
        'headers'     => [
            'Authorization' => 'Basic ' . $auth_token,
            'Content-Type'  => 'application/json',
        ],
    ];
    $response = wp_remote_request($query_url, $args);
    if (is_wp_error($response)) {
        error_log('Request failed: ' . $response->get_error_message());
        return false;
    }
    $status_code = wp_remote_retrieve_response_code($response);
    $response_body = wp_remote_retrieve_body($response);
    //error_log('Get Response Code: ' . $status_code);
    //error_log('Get Response Body: ' . $response_body);
    return [
        'status' => $status_code,
        'body'   => json_decode($response_body, true),
    ];
} // END GET function

public function put_data($json, $auth_token, $query_url_endpoint) { // PUT function
    $query_url = $this->baseurl . $query_url_endpoint;
    $args = [
        'method'      => 'PUT', 
        'timeout'     => 60,
        'redirection' => 10,
        'headers'     => [
            'Authorization' => 'Basic ' . $auth_token,
            'Content-Type'  => 'application/json',
        ],
        'body'        => $json, 
    ];
    $response = wp_remote_request($query_url, $args);
    if (is_wp_error($response)) {
        error_log('Request failed: ' . $response->get_error_message());
        return false;
    }
    $status_code = wp_remote_retrieve_response_code($response);
    $response_body = wp_remote_retrieve_body($response);
    //error_log('Put Response Code: ' . $status_code);
   // error_log('Put Response Body: ' . $response_body);
    return [
        'status' => $status_code,
        'body'   => json_decode($response_body, true),
    ];
}  // END PUT function

}
?>