<?php
if (!defined('ABSPATH')) exit;

class DFY_Admin_Scripts {

    public static function init() {
         add_action('admin_enqueue_scripts', array(__CLASS__, 'enqueue_scripts'));
    }

    public static function enqueue_scripts($hook) {
        if (strpos($hook, 'toplevel_page_gf_edit_forms') === false &&  strpos($hook, 'gf_edit_forms') === false &&  strpos($hook, 'forms_page_gf_settings') === false) { 
            return;
        }
        wp_register_style('gfdtstylesheet',  plugin_dir_url(__FILE__) . '../assets/css/gfdt.css' );
        wp_enqueue_style('gfdtstylesheet');

        $enabled_form_ids = get_option('gfdt_field_mapping_enabled', '');
        $form_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

        if ($form_id > 0 && in_array($form_id, explode(',', $enabled_form_ids))) {
            // Enqueue the JavaScript file (if the form ID is found in the list)
            wp_enqueue_script(
                'dfy-admin-js',
                plugin_dir_url(__FILE__) . '../assets/js/gfdt-label-mapping.js',
                ['jquery'],
                '1.0',
                true
            );

            // Localize script with the current form ID and other data
            wp_localize_script('dfy-admin-js', 'gfdtData', [
                'formId' => $form_id,
                'donorfyEnabled' => true
            ]);
        }
    }
}

