jQuery(document).ready(function($) {
	function updateAdminFieldLabel(newLabelText) {
        var $label = $('.admin_label_setting.field_setting label.section_label'); 
		
        $label.contents().filter(function() {
            return this.nodeType === 3; 
        }).first().replaceWith(newLabelText); 
		
    }
    updateAdminFieldLabel('Donorfy Mapping');
	
    var adminLabelOptions = [
        { value: '', label: 'Select mapping data' },
        { value: 'Address', label: 'Address' },
        { value: 'AddressLine1', label: 'Address Line1' },
        { value: 'AddressLine2', label: 'Address Line2' },
        { value: 'ConstituentType', label: 'Constituent Type' },
        { value: 'County', label: 'County' },
        { value: 'Country', label: 'Country' },
		{ value: 'DateOfBirth', label: 'Date Of Birth' },
		{ value: 'DonationAmount', label: 'Donation Amount' },
		{ value: 'DonationBankAccount', label: 'Donation Bank Account' },
        { value: 'DonationCurrency', label: 'Donation Currency' },
		{ value: 'DonationDepartment', label: 'Donation Department' },
        { value: 'DonationCampaign', label: 'Donation Campaign' },
		{ value: 'DonationChannel', label: 'Donation Channel' },
		{ value: 'DonationComments', label: 'Donation Comment' },
		{ value: 'DonationFund', label: 'Donation Fund' },
		{ value: 'DonationPaymentMethod', label: 'Donation Payment Method' },
		{ value: 'DonationProduct', label: 'Donation Product' },
		{ value: 'EmailAddress', label: 'Email Address' },
        { value: 'FirstName', label: 'First Name' },
        { value: 'Fullname', label: 'Full Name' },
        { value: 'Gender', label: 'Gender' },
        { value: 'GiftAidOptIn', label: 'Gift Aid Opt In' },
        { value: 'GiftAidDeclarationMethod', label: 'GiftAid Declaration Method' },
        { value: 'HouseBuildingNumber', label: 'House Building Number' },
        { value: 'LastName', label: 'Last Name' },
		{ value: 'OrderItem', label: 'Order Item' },
		{ value: 'OrderBankAccount', label: 'Order Bank Account' },
		{ value: 'OrderCampaign', label: 'Order Campaign' },
		{ value: 'OrderCurrency', label: 'Order Currency' },
		{ value: 'OrderDepartment', label: 'Order Department' },
		{ value: 'OrderFund', label: 'Order Fund' },
		{ value: 'OrderPaymentMethod', label: 'Order Payment Method' },
		{ value: 'OrderProduct', label: 'Order Product' },
        { value: 'OrganisationName', label: 'Organisation Name' },
		{ value: 'Amount', label: 'Payment Total' },
		{ value: 'EmailPermission', label: 'Permission for Email' },
		{ value: 'PhonePermission', label: 'Permission for Phone' },
        { value: 'PostPermission', label: 'Permission for Post' },
		{ value: 'SMSPermission', label: 'Permission for SMS' },
        { value: 'Phone1', label: 'Phone Number' },
		{ value: 'PostalCode', label: 'PostalCode' },
		{ value: 'Purpose', label: 'Purpose' },
       	{ value: 'Tag', label: 'Tag' },
        { value: 'Title', label: 'Title' },
        { value: 'Town', label: 'Town' },
        { value: 'ActivityType', label: 'Activity Type' },
		{ value: 'Code1', label: 'Code1' },
        { value: 'Code2', label: 'Code2' },
        { value: 'Code3', label: 'Code3' },
        { value: 'Code4', label: 'Code4' },
        { value: 'Code5', label: 'Code5' },
        { value: 'Code6', label: 'Code6' },
        { value: 'Code7', label: 'Code7' },
        { value: 'Code8', label: 'Code8' },
        { value: 'Code9', label: 'Code9' },
		{ value: 'Code10', label: 'Code10' },
        { value: 'Date1', label: 'Date1' },
        { value: 'Date2', label: 'Date2' },
        { value: 'Date3', label: 'Date3' },
        { value: 'Date4', label: 'Date4' },
        { value: 'Date5', label: 'Date5' },
        { value: 'Date6', label: 'Date6' },
        { value: 'Date7', label: 'Date7' },
        { value: 'Date8', label: 'Date8' },
        { value: 'Date9', label: 'Date9' },
        { value: 'Date10', label: 'Date10' },
        { value: 'Number1', label: 'Number1' },
        { value: 'Number2', label: 'Number2' },
        { value: 'Number3', label: 'Number3' },
        { value: 'Number4', label: 'Number4' },
        { value: 'Number5', label: 'Number5' },
        { value: 'Number6', label: 'Number6' },
        { value: 'Number7', label: 'Number7' },
        { value: 'Number8', label: 'Number8' },
        { value: 'Number9', label: 'Number9' },
        { value: 'Number10', label: 'Number10' },
		{ value: 'YesNo1', label: 'YesNo1' },
        { value: 'YesNo2', label: 'YesNo2' },
        { value: 'YesNo3', label: 'YesNo3' },
        { value: 'YesNo4', label: 'YesNo4' },
        { value: 'YesNo5', label: 'YesNo5' },
        { value: 'YesNo6', label: 'YesNo6' },
        { value: 'YesNo7', label: 'YesNo7' },
        { value: 'YesNo8', label: 'YesNo8' },
        { value: 'YesNo9', label: 'YesNo9' },
		{ value: 'YesNo10', label: 'YesNo10' },
		{ value: 'ActivityNotes', label: 'Activity Notes' },
		
		      		
   ];

    // Function to convert admin label input to select field
    function convertAdminLabelToSelect() {
        $('.sidebar__panel.sidebar__panel--settings.ui-tabs-panel.ui-corner-bottom.ui-widget-content').find('input[id="field_admin_label"]').each(function() {
            var $input = $(this);
            var currentValue = $input.val().trim(); // Get trimmed value
            var fieldId = $input.closest('.sidebar__panel').find('#sidebar_field_label').data('fieldid');
            //var selectId = 'select_field_' + fieldId;
			var selectId = 'select_field_dfyMap';

            // Check if a select field already exists for this input
            var $select = $input.next('select');
            if (!$select.length) {
                $select = $('<select>', {
                    id: selectId, // Unique ID for select field
                    name: $input.attr('name')
                });

                adminLabelOptions.forEach(function(option) {
                    var $option = $('<option>', {
                        value: option.value,
                        text: option.label,
                        selected: option.value === currentValue
                    });
                    $select.append($option);
                });

                // Event handler for select field change
                $select.on('change', function() {
                    var selectedValue = $select.val();
                    $input.val(selectedValue.trim()).trigger('input'); // Update input value and trigger input event
                    //console.log("Admin label updated to:", selectedValue);
                });

                $input.after($select);
            } else {
                // Update selected option based on currentValue
                $select.val(currentValue);
            }
        });
    }

    convertAdminLabelToSelect();

    $(document).bind('gform_load_field_settings', function(event, field, form) {
        convertAdminLabelToSelect();
		  updateAdminFieldLabel('Donorfy Mapping');
    });
});
