<?php
if (!defined('ABSPATH')) exit; // Prevent direct access

class GFDT_Form_Settings {

    public static function init() {
        // Add custom menu and subview to the Gravity Forms form settings page
        add_filter('gform_form_settings_menu', [__CLASS__, 'add_form_settings_menu_item']);
        add_action('gform_form_settings_page_gfdt_field_mapping', [__CLASS__, 'render_form_settings_page']);

        add_filter('gform_settings_menu', [__CLASS__, 'add_donorfy_settings_tab']);
        add_action('gform_settings_donorfy', [__CLASS__, 'render_donorfy_settings_page'], 10, 1);

        // Enqueue scripts for AJAX
        add_action('admin_enqueue_scripts', [__CLASS__, 'enqueue_scripts']);
        
        // Handle the AJAX request for saving settings
        add_action('wp_ajax_gfdt_save_settings', [__CLASS__, 'gfdt_save_settings_handler']);
        add_action('wp_ajax_nopriv_gfdt_save_settings', [__CLASS__, 'gfdt_save_settings_handler']); 
        add_action('wp_ajax_gfdt_save_core_settings', [__CLASS__, 'gfdt_save_core_settings_handler']);
        add_action('wp_ajax_nopriv_gfdt_save_core_settings', [__CLASS__, 'gfdt_save_core_settings_handler']);

        // Modify front end of form with custom IDs, javascript presence and so on
        add_filter('gform_form_tag', [__CLASS__, 'add_donation_form_attributes'], 10, 2);
        add_filter('gform_field_content', [__CLASS__, 'add_field_admin_labels'], 10, 5);

        // Custom Confirmation in the event of optional donation
        add_filter( 'gform_pre_confirmation', 'opt_donation_confirmation_message', 10, 2 );
    }



    
    /**
     * Add a new subview to the Form Settings menu.
     */
    public static function add_form_settings_menu_item($menu_items) {
        $menu_items[] = [
            'name'  => 'gfdt_field_mapping',
            'label' => esc_html__('Donorfy Mapping', 'gfdt'),
            'icon'  => plugin_dir_url(__FILE__) . '../assets/images/donorfy-icon.png'
        ];
        return $menu_items;
    }


    public static function add_donorfy_settings_tab($tabs) {
        // Add a new tab for Donorfy settings
        $tabs['donorfy'] = [
            'name' => 'donorfy',
            'label' => esc_html__('Donorfy', 'gfdt'), 
            'icon'  => plugin_dir_url(__FILE__) . '../assets/images/donorfy-icon.png'
        ];
        return $tabs;
    }


    /**
     * Render the form settings page.
     */
    public static function render_form_settings_page($form) {
        GFFormSettings::page_header();

        // Check if API keys are set
        $CTID = get_option('gfdt_CTID', '');
        if (empty($CTID) || $CTID === '0') {
            ?>
            <div class="notice notice-error">
               <p>
        <?php 
        printf(
            esc_html__('You cannot use Donorfy mapping without a valid Charity Toolkit ID. Please add yours in the %1$splugin settings%2$s.', 'gfdt'),
            '<a href="' . esc_url(admin_url('admin.php?page=gf_settings&subview=donorfy')) . '">',
            '</a>'
        );
        ?>
    </p>
            </div>
            <?php
            GFFormSettings::page_footer();
            return;
        }

        // Retrieve saved values
        $enabled_form_ids = get_option('gfdt_field_mapping_enabled', '');
        $form_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
        $is_enabled = in_array($form_id, explode(',', $enabled_form_ids));
        $campaigns = get_option('gfdt_campaign', '');
        $campaign_value = '';
        if (!empty($campaigns)) {
            $campaigns_array = explode(',', $campaigns);
        
            foreach ($campaigns_array as $campaign_pair) {
                $pair_parts = explode('--', $campaign_pair);
                                if (isset($pair_parts[0]) && intval($pair_parts[0]) === $form_id) {
                    $campaign_value = isset($pair_parts[1]) ? $pair_parts[1] : '';
                    break;
                }
            }
        }
        
        

        ?>
    <form id="gfdt-settings" class="gform_settings_form" method="post" novalidate="novalidate">
        <fieldset id="gform-settings-section-general-settings" class="gform-settings-panel gform-settings-panel--full gform-settings-panel--with-title">
            <legend class="gform-settings-panel__title gform-settings-panel__title--header"><?php esc_html_e('Donorfy Field Mapping Settings', 'gfdt'); ?></legend>

        <div class="gform-settings-panel">
           
            <div class="gform-settings-panel__content">
               
                    <?php wp_nonce_field('gfdt_field_mapping_save', 'gfdt_field_mapping_nonce'); ?>
                    <table class="form-table">
                        <tr>
                            <th scope="row">
                                <label for="gfdt_field_mapping_enabled"><?php esc_html_e('Enable Field Mapping', 'gfdt'); ?></label>
                            </th>
                            <td>
                                <input type="checkbox" id="gfdt_field_mapping_enabled" name="gfdt_field_mapping_enabled" value="<?php echo isset($_GET['id']) ? intval($_GET['id']) : ''; ?>" <?php checked($is_enabled, true); ?>">
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="gfdt_campaign"><?php esc_html_e('Default Donorfy Campaign', 'gfdt'); ?></label><br>
                                <small>Elect a Donorfy Campaign to use by default if you do not include one in your field mapping</small>
                            </th>
                            <td>
                                <input type="text" name="gfdt_campaign" id="gfdt_campaign" value="<?php echo esc_attr($campaign_value); ?>" class="regular-text">
                            </td>
                        </tr>
                        
                        
                    </table>
                   
                
            </div>
        </div>
    </fieldset>
    <div class="gform-settings-save-container">
      <button type="submit" class="button primary"><?php esc_html_e('Save Settings', 'gfdt'); ?></button>
      <div id="gfdt-message"></div>
    </div>
    </form>
        <?php

        GFFormSettings::page_footer();
    }

/**
     * Render the Core Settings
     */

     public static function render_donorfy_settings_page() {        
        // Retrieve saved values
        $CTID = get_option('gfdt_CTID', '');
        $CTID = $CTID === '0' ? '' : $CTID;
        ?>
        <form id="gfdt-donorfy-settings" class="gform_settings_form" method="post" novalidate="novalidate">
            <fieldset id="gform-settings-section-donorfy-settings" class="gform-settings-panel gform-settings-panel--full gform-settings-panel--with-title">
                <legend class="gform-settings-panel__title gform-settings-panel__title--header"><?php esc_html_e('Donorfy Integration Settings', 'gfdt'); ?></legend>
    
                <div class="gform-settings-panel">
                    <div class="gform-settings-panel__content">
                        <?php wp_nonce_field('gfdt_core_save', 'gfdt_core_nonce'); ?>
    
                        <table class="form-table">
                            <tr>
                                <th scope="row">
                                    <label for="gfdt_CTID"><?php esc_html_e('Charity Toolkit ID', 'gfdt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" name="gfdt_CTID" id="gfdt_CTID" value="<?php echo esc_attr($CTID); ?>" class="regular-text">
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </fieldset>
    
            <div class="gform-settings-save-container">
                <button type="submit" class="button primary"><?php esc_html_e('Save Settings', 'gfdt'); ?></button>
                <button  class="button" id="gfdt-clear-settings" name="gfdt_clear_settings" value="1"><?php esc_html_e('Clear Settings', 'gfdt'); ?></button>
                <div id="gfdt-message"></div>
            </div>
        </form>
        <?php
    }


     /**
     * Get custom admin labelling and append to fields on front end
     */
    public static function add_field_admin_labels($content, $field, $value, $lead_id, $form_id) {
        if (!empty($field->adminLabel)) {
            $admin_label = sanitize_title($field->adminLabel);
            $content = preg_replace('/<(input|select|textarea)(?![^>]*data-dfy)/', 
            '<$1 data-dfy="gfdt-field-' . $admin_label . '"',  
            $content); 
    
        }
        return $content;
    }
    public static function add_donation_form_attributes($form_tag, $form) {
    $enabled_form_ids = get_option('gfdt_field_mapping_enabled', '');
    $enabled_form_ids = explode(',', $enabled_form_ids); 
    if (in_array($form['id'], $enabled_form_ids)) {
        $form_tag = str_replace('<form', '<form name="donorfy-enabled" ', $form_tag);
    }
    return $form_tag;
}
    











    /**
     * Enqueue necessary scripts for handling AJAX
     */
    public static function enqueue_scripts($hook) {
        // Only enqueue on the Gravity Forms settings page
        if ('toplevel_page_gf_edit_forms' !== $hook && 'gf_edit_forms' !== $hook && 'forms_page_gf_settings' !== $hook ) {
            return;
        }

        // Enqueue custom ajax file
        wp_enqueue_script('gfdt-ajax', plugin_dir_url(dirname(__FILE__)) .  'assets/js/gfdt-ajax.js', ['jquery'], null, true);

        // Localize script to pass AJAX URL and nonce
       wp_localize_script('gfdt-ajax', 'gfdt_ajax_obj', [
        'nonce' => wp_create_nonce('gfdt_ajax_nonce'), 
        'ajax_url' => admin_url('admin-ajax.php'),  
    ]);
    }

    

    // Save Form settings
    public static function gfdt_save_settings_handler() {
        if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'gfdt_ajax_nonce')) {
            wp_send_json_error(['message' => 'Nonce verification failed']);
        }

        $form_id = isset($_POST['gfdt_form_id']) ? intval($_POST['gfdt_form_id']) : 0;
        $enabled = isset($_POST['gfdt_field_mapping_enabled']) ? $_POST['gfdt_field_mapping_enabled'] : '0';
        $defaultCampaign = isset($_POST['gfdt_campaign']) ? sanitize_text_field($_POST['gfdt_campaign']) : '';

        $enabled_forms = get_option('gfdt_field_mapping_enabled', '');
        $enabled_forms_array = explode(',', $enabled_forms);
        if ($enabled === '1' && !in_array($form_id, $enabled_forms_array)) {
            $enabled_forms_array[] = $form_id; 
        }
    
        if ($enabled === '0' && in_array($form_id, $enabled_forms_array)) {
            $enabled_forms_array = array_diff($enabled_forms_array, [$form_id]); 
        }
    
        $enabled_forms = implode(',', array_map('intval', $enabled_forms_array));
        $campaigns = get_option('gfdt_campaign', '');
        $campaigns_array = explode(',', $campaigns);
        $campaign_pair = $form_id . '--' . $defaultCampaign;
        $campaign_exists = false;
        foreach ($campaigns_array as $index => $pair) {
            if (strpos($pair, $form_id . '--') === 0) {
                $campaigns_array[$index] = $campaign_pair;
                $campaign_exists = true;
                break;
            }
        }
        if (!$campaign_exists) {
            $campaigns_array[] = $campaign_pair;
        }
        $campaigns = implode(',', $campaigns_array);


        // Save the options in wp_options
        update_option('gfdt_field_mapping_enabled', $enabled_forms);
        update_option('gfdt_campaign', $campaigns);

        // Send success response
        wp_send_json_success(['message' => 'Settings saved successfully']);
    }

//Save Core settings
    public static function gfdt_save_core_settings_handler() {
        // Verify nonce
        if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'gfdt_ajax_nonce')) {
            wp_send_json_error(['message' => 'Nonce verification failed']);
        }
        
        // Retrieve settings from POST data
        $CTID = isset($_POST['gfdt_CTID']) ? sanitize_text_field($_POST['gfdt_CTID']) : '0';
        if ($CTID === '') { $CTID = '0'; }
        
        // Save the settings in the options table
        update_option('gfdt_CTID', $CTID);
    
        // Return success response
        wp_send_json_success(['message' => 'Settings saved successfully']);
    }
}

GFDT_Form_Settings::init();
?>
